
                    // File  "OrderPayingAndSupplying.java"
                       // File OrderPayingAndSupplying.java representing the complex process OrderPayingAndSupplying
                      // DeclarationSection 
                          // PackageDeclaration 
                              package OrderSystem;
                         
                         // FileImport  "opmTypes.*"
                              import opmTypes.*;
                          
                       
                       // Class  "OrderPayingAndSupplying"
                            public class OrderPayingAndSupplying extends opmProcess {
                            // AttributeSection      
                            
                            // MethodSection 
                                // Method  "OrderPayingAndSupplying" 
                                    public OrderPayingAndSupplying (
                                       // ParamSection  "OrderPayingAndSupplying" 
                                       
                                      ) {
                                        // MethodBodySection  "OrderPayingAndSupplying"
                                        
                                    }
                                 
                               // Method  "preConditionHolds" 
                                    public boolean preConditionHolds (
                                         // ParamSection  "preConditionHolds" 
                                         
                                       // PreConditionHoldsParam  "theInventoryEmpty"
                        Boolean theInventoryEmpty
               
               
                                           ) {
                                         boolean check = true;
                                       // PreConditionHoldsStructure  "condition"
                                       
                                if (! (// ConditionParamSection 
                                      // ConditionParam  "theInventoryEmptyfalse"
                                (theInventoryEmpty.booleanValue()==false)
               
                                      
                               || // ConditionParam  "theInventoryEmptytrue"
                                (theInventoryEmpty.booleanValue()==true)
               
                ))
                                     check=false;
               
                                        if (check) {
                                              // PreConditionHoldsStructure  "loop"
                                              
                                        }
                                        return check;
                                    }
                                 
                                 // Method  "run" 
                                    public void run (
                                         // ParamSection  "run" 
                                         
                    // RunParam  "theInventoryEmpty"
                          Boolean theInventoryEmpty
               
               
                    , 
                    // RunParam  "theOrder" 
                          Order theOrder
                    
               
                    , 
                    // RunParam  "theProduct" 
                          Product theProduct
                    
               
                    , 
                    // RunParam  "theReceipt" 
                          Receipt theReceipt
                    
               
                                           ) {
                                         if (preConditionHolds (// ParamSection  "runPreConditionHolds" 
                                                                             
                                       // RunPreConditionHoldsParam  "theInventoryEmpty"
                                                    theInventoryEmpty
                                        
               
                                                                            )) {
                                                // MethodBodySection  "run"
                                                
                                                 // Effect theOrder
               
                                                 // Effect theProduct
               
                                                 // Yield theReceipt
               
                                                 theReceipt = new Receipt();
               
                       OrderPaying  theOrderPaying = new OrderPaying();
                       theOrderPaying.run(                    
                                         // ParamSection  "runOrderPaying" 
                                         
                    // FirstRunParam  "runOrderPaying"
                    // RunParam  "OrderPayingOrder" 
                          theOrder
                    
               
                    , 
                    // RunParam  "OrderPayingReceipt" 
                          theReceipt
                    
               );
               
                       OrderSupplying  theOrderSupplying = new OrderSupplying();
                       theOrderSupplying.run(                    
                                         // ParamSection  "runOrderSupplying" 
                                         
                    // FirstRunParam  "runOrderSupplying"
                    // RunParam  "OrderSupplyingProduct" 
                          theProduct
                    
               
                    , 
                    // RunParam  "OrderSupplyingOrder" 
                          theOrder
                    
               );
               
                                          }
                                    }
                                 
                             
                         // ClassFooter  "OrderPayingAndSupplying"
                           }
                          
                       
                    
               