
                    // File  "Order.java"
                       // File Order.java representing the complex object Order
                      // DeclarationSection 
                         // PackageDeclaration 
                              package OrderSystem;
                         
                         // FileImport  "opmTypes.*"
                              import opmTypes.*;
                          
                       
                    // FileImport  "java.util.Date"
                              import java.util.Date;
                          
               
                       // Class  "Order"
                             public class Order extends opmObject {
                             // AttributeSection      
                            
                    // Attribute  "theStatus"
                        opmStatus theStatus;
                    
               
                    // Attribute  "OrderNumber"
                        Integer theOrderNumber;
                    
               
                    // Attribute  "OrderDate"
                        Date theOrderDate;
                    
               
                    // Attribute  "theisownedbyCustomer"
                        Customer theisownedbyCustomer;
                    
               
                    // Attribute  "therelatestoProduct"
                    // Between 1 and 1000 instances of Order can be connected to a single Product
               
                        Product therelatestoProduct;
                    
               
                    // Attribute  "thearerelatedReceipt"
                        Receipt thearerelatedReceipt;
                    
               
                            // MethodSection 
                                // Method  "Order" 
                                    public Order (
                                          // ParamSection  "Order" 
                                          
                                          ) {
                                      // MethodBodySection  "Order"
                                      
                        theStatus = new opmStatus();
                        initializeStatus();
               
                                    }
                                 
                             
                                 // Method  "initializeStatus" 
                                    public void initializeStatus () {
                                      // MethodBodySection  "initializeStatus"
                                      
                         theStatus.addState(new opmState("ordered", true, false, true));
               
                         theStatus.addState(new opmState("paid", true, false, false));
               
                         theStatus.addState(new opmState("supplied", false, true, false));
               
                         theStatus.addState(new opmState("cancelled", false, true, false));
               
                                    }
                                 
               
                    // Method  "ChangeOrderDetails"
                       public void ChangeOrderDetails (
                                  // MethodParamSection  "ChangeOrderDetails"
                                  
                    // FirstMethodParam  "ChangeOrderDetails"
                    // MethodParam  "ChangeOrderDetailsOrder" 
                         Order theOrder
                    
                ) {
                                 // MethodBodySection  "ChangeOrderDetails"
                                 
                       ChangeOrderDetails  theChangeOrderDetails = new ChangeOrderDetails();
                       theChangeOrderDetails.run(
                                         // ParamSection  "runChangeOrderDetails" 
                                         
                    // FirstRunParam  "runChangeOrderDetails"
                    // RunParam  "ChangeOrderDetailsOrder" 
                          theOrder
                    
               );
               
                       }
                    
               
                    // Method  "gettheOrderNumber"
                        public int gettheOrderNumber() {
                            return theOrderNumber.intValue();
                       }
                    
                    // Method  "settheOrderNumber"
                        public void settheOrderNumber(int newOrderNumber) {
                             theOrderNumber= new Integer(newOrderNumber);
                       }
                    
               
                    // Method  "gettheOrderDate"
                        public Date gettheOrderDate() {
                            return theOrderDate;
                       }
                    
                    // Method  "settheOrderDate"
                        public void settheOrderDate(Date newOrderDate) {
                             theOrderDate= newOrderDate;
                       }
                    
               
                    // Method  "gettheisownedbyCustomer"
                        public Customer gettheisownedbyCustomer() {
                            return theisownedbyCustomer;
                       }
                    
                    // Method  "settheisownedbyCustomer"
                        public void settheisownedbyCustomer (Customer newisownedbyCustomer) {
                             theisownedbyCustomer= newisownedbyCustomer;
                       }
                    
               
                    // Method  "gettherelatestoProduct"
                        public Product gettherelatestoProduct() {
                            return therelatestoProduct;
                       }
                    
                    // Method  "settherelatestoProduct"
                        public void settherelatestoProduct (Product newrelatestoProduct) {
                             therelatestoProduct= newrelatestoProduct;
                       }
                    
               
                    // Method  "getthearerelatedReceipt"
                        public Receipt getthearerelatedReceipt() {
                            return thearerelatedReceipt;
                       }
                    
                    // Method  "setthearerelatedReceipt"
                        public void setthearerelatedReceipt (Receipt newarerelatedReceipt) {
                             thearerelatedReceipt= newarerelatedReceipt;
                       }
                    
               
                                                 // Method  "finalize"
                                                           protected void finalize() {
                                                           }
                                                   
               
                         // ClassFooter  "Order"
                           }
                          
                       
                    
               