/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Formatter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class GUI
extends JFrame {
    private JLabel file;
    private JTextField fileT;
    private JButton fileB;
    private JCheckBox flip;
    private JLabel smooth;
    private JTextField smoothT;
    private JButton doIt;

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void main(String[] args) {
        GUI g = new GUI();
        g.setDefaultCloseOperation(3);
        g.setSize(750, 400);
        g.setVisible(true);
    }

    public GUI() {
        super("Gui for DoR");
        this.setLayout(new FlowLayout());
        this.file = new JLabel("File name");
        this.add(this.file);
        this.fileT = new JTextField(50);
        this.add(this.fileT);
        this.fileB = new JButton("Choose");
        this.add(this.fileB);
        this.flip = new JCheckBox("Flip?", false);
        this.add(this.flip);
        this.smooth = new JLabel("Smoothing");
        this.add(this.smooth);
        this.smoothT = new JTextField("1.00");
        this.smoothT.setFont(new Font("Serif", 0, 14));
        this.add(this.smoothT);
        this.doIt = new JButton("Go");
        this.add(this.doIt);
        this.fileB.addActionListener(new FileChooser());
        this.doIt.addActionListener(new DoIt());
    }

    private class DoIt
    implements ActionListener {
        private DoIt() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                String line;
                double sm = Double.parseDouble(GUI.this.smoothT.getText());
                System.out.printf("Input\n%s\nFlip\n%d\nSmooth\n%g\n", GUI.this.fileT.getText(), GUI.this.flip.isSelected() ? 1 : 0, sm);
                Formatter output = new Formatter("Data.ini");
                output.format("Input\n%s\nFlip\n%d\nSmooth\n%g\n", GUI.this.fileT.getText(), GUI.this.flip.isSelected() ? 1 : 0, sm);
                output.close();
                Process p = Runtime.getRuntime().exec("cmd /c dir");
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = bri.readLine()) != null) {
                    System.out.println(line);
                }
                bri.close();
                while ((line = bre.readLine()) != null) {
                    System.out.println(line);
                }
                bre.close();
                p.waitFor();
                System.out.println("Done.");
                Process p2 = Runtime.getRuntime().exec("Curves.exe");
                BufferedReader bre2 = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
                while ((line = bre2.readLine()) != null) {
                    System.out.println(line);
                }
                bre2.close();
                p2.waitFor();
                System.out.println("Done2.");
            }
            catch (Exception e) {
                System.out.println(e);
                JOptionPane.showMessageDialog(GUI.this, String.valueOf(GUI.this.smoothT.getText()) + " is not a number", "Smoothing is not a number", 0);
            }
        }
    }

    private class FileChooser
    implements ActionListener {
        private FileChooser() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser();
            PlyFilter ff = new PlyFilter();
            fc.setFileFilter(ff);
            fc.setCurrentDirectory(new File("."));
            int result = fc.showDialog(GUI.this, "Choose file");
            if (result == 1) {
                return;
            }
            File f = fc.getSelectedFile();
            GUI.this.fileT.setText(f.getPath());
        }

        private class PlyFilter
        extends FileFilter {
            private PlyFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = GUI.getExtension(f);
                if (extension != null) {
                    return extension.equals("PLY") || extension.equals("ply");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "PLY 3D files";
            }
        }
    }
}

